<?php
/*
File: inc/functions.php
Description: Plugin functions
Plugin: Elementor Page Intro
Author: AD-THEME
*/

// TEMPLATE REDIRECT

add_action( 'template_redirect', 'elementor_page_intro_page' );

function elementor_page_intro_page() {
	$epi_settings = get_option('elementor-page-intro_settings');
	$page_intro_active = $epi_settings['page_intro_active'];
	$page_intro_active_pages = $epi_settings['page_intro_active_pages'];
	$page_intro_type = $epi_settings['page_intro_type'];
	$page_intro_cookie_value = $epi_settings['page_intro_cookie_value'];

	if($page_intro_active == 'yes') {
		
		if($page_intro_active_pages == 'homepage') {
		
			if ( (is_home() || is_front_page()) ) {
				/* NORMAL */
				if($page_intro_type == 'normal') {
					add_filter( 'template_include', 'elementor_page_intro_tpl' );
				}
				/* SESSION */
				if($page_intro_type == 'session') {	
					session_start();
					if (!isset($_SESSION['SessionFirstVisit'])) {
						$_SESSION['SessionFirstVisit'] = 1;
						add_filter( 'template_include', 'elementor_page_intro_tpl' );
					}
				}
				/* COOKIE */
				if($page_intro_type == 'cookie') {
					if (!isset($_COOKIE['FirstVisit'])) {
						setcookie ('FirstVisit', 'yes', time() + $page_intro_cookie_value);		
						add_filter( 'template_include', 'elementor_page_intro_tpl' );
					}
				}			
			}
		
		} else {
		
			if($page_intro_type == 'normal') {
				add_filter( 'template_include', 'elementor_page_intro_tpl' );
			}
			/* SESSION */
			if($page_intro_type == 'session') {	
				session_start();
    			if (!isset($_SESSION['SessionFirstVisit'])) {	
					$_SESSION['SessionFirstVisit'] = 1;
					add_filter( 'template_include', 'elementor_page_intro_tpl' );
				}
			}
			/* COOKIE */
			if($page_intro_type == 'cookie') {
    			if (!isset($_COOKIE['FirstVisit'])) {
					setcookie ('FirstVisit', 'yes', time() + $page_intro_cookie_value);		
					add_filter( 'template_include', 'elementor_page_intro_tpl' );
				}
			}			
			
		}
	}
}

function elementor_page_intro_tpl() {
       
	$layout = EPI_DIR . '/inc/template.php';

	return $layout;
  
}

// MENU
if(!function_exists('elementor_page_intro_menu')):
function elementor_page_intro_menu() {
	register_nav_menus(
		array(
			'epageintro-menu' => esc_html__( 'Elementor Page Intro Menu', 'elementor-page-intro' )
		)
	);
	register_nav_menus(
		array(
			'epageintro-menu-2' => esc_html__( 'Elementor Page Intro Menu 2', 'elementor-page-intro' )
		)
	);	
}		
endif;
add_action('init', 'elementor_page_intro_menu');